/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V2.0.1
* Date               : 06/13/2008
* Description        : Main program body.
********************************************************************************
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_lib.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
GPIO_InitTypeDef GPIO_InitStructure;
NVIC_InitTypeDef NVIC_InitStructure;
ErrorStatus HSEStartUpStatus;
volatile unsigned int LedState = 0x01;
volatile unsigned char RTC_Update = 0;

/* Private function prototypes -----------------------------------------------*/
void RCC_Configuration(void);
void NVIC_Configuration(void);
void RTCIntrHandler(void);
void RtcSetup (void); 
void Delay(vu32 nCount);

/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main program.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main(void)
{
#ifdef DEBUG
  debug();
#endif

  /* System Clocks Configuration **********************************************/
  RCC_Configuration();   

  /* NVIC Configuration *******************************************************/
  NVIC_Configuration();

  /* SysTick end of count event each 1ms with input clock equal to 9MHz (HCLK/8, default) */
  SysTick_SetReload(9000);

  /* Enable SysTick interrupt */
  SysTick_ITConfig(ENABLE);

  /* Configure All GPIO = Output */
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA |         // GPIO:PA
                         RCC_APB2Periph_GPIOB |         // GPIO:PB
                         RCC_APB2Periph_GPIOC |         // GPIO:PC
                         RCC_APB2Periph_GPIOD |         // GPIO:PD
                         RCC_APB2Periph_AFIO ,          // Remap JTAG -> GPIO
                         ENABLE);

  /* Disable the Serial Wire Jtag Debug Port SWJ-DP */
  /* Remapping JTAG to PA[13...15],PB[3...4] = GPIO */
  // PA13 = JTMS/SWDAT  --> GPIO
  // PA14 = JTCK/SWCLK  --> GPIO
  // PA15 = JTDI        --> GPIO
  // PB3  = JTDO        --> GPIO
  // PB4  = JTRST       --> GPIO
  GPIO_PinRemapConfig(GPIO_Remap_SWJ_Disable, ENABLE);  // Remap JTAG to GPIO
  
  // PA[0..15] = Output(Reserve PA9=TX,PA10=RX)
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0  | GPIO_Pin_1  | 
                                GPIO_Pin_2  |GPIO_Pin_3   |
                                GPIO_Pin_4  | GPIO_Pin_5  | 
                                GPIO_Pin_6  |GPIO_Pin_7   |                               
                                GPIO_Pin_8  | GPIO_Pin_11 |
                                GPIO_Pin_12 | GPIO_Pin_13 | 
                                GPIO_Pin_14 |GPIO_Pin_15;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOA, &GPIO_InitStructure);
  
  // PB[0,1,3..15] = Output(Reserve PB2=BOOT1:GND)
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0  | GPIO_Pin_1  | 
                                GPIO_Pin_3  |
                                GPIO_Pin_4  | GPIO_Pin_5  | 
                                GPIO_Pin_6  |GPIO_Pin_7   |                               
                                GPIO_Pin_8  | GPIO_Pin_9  | 
                                GPIO_Pin_10 |GPIO_Pin_11  |
                                GPIO_Pin_12 | GPIO_Pin_13 | 
                                GPIO_Pin_14 |GPIO_Pin_15;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOB, &GPIO_InitStructure);
  
  // PC[0..13] = Output(Reserve PC14=OSCI,PC15=OSCO)
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0  | GPIO_Pin_1  |
                                GPIO_Pin_2  |GPIO_Pin_3   |
                                GPIO_Pin_4  | GPIO_Pin_5  | 
                                GPIO_Pin_6  |GPIO_Pin_7   |                               
                                GPIO_Pin_8  | GPIO_Pin_9  | 
                                GPIO_Pin_10 |GPIO_Pin_11  |
                                GPIO_Pin_12 | GPIO_Pin_13;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOC, &GPIO_InitStructure);
  
  // PD[2] = Output(Reserve PD0=OSCIN,PD1=OSCOUT)
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_2; 
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOD, &GPIO_InitStructure);
  
  /* Config RTC Interrupt Every 1-Sec Trig LED */
  /* Configure one bit for preemption priority */
  NVIC_PriorityGroupConfig(NVIC_PriorityGroup_1);

  /* Enable the RTC Interrupt */
  NVIC_InitStructure.NVIC_IRQChannel = RTC_IRQChannel;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 1;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Init(&NVIC_InitStructure);
  
  RtcSetup();         // Start RTC
  LedState = 0x01;    // LED Status
  
  /* Main Start Here */
  while(1)	  											
  {
     // RTC Trigger LED Moving on GPIO Port
     if (RTC_Update == 1)  
     {
       RTC_Update = 0; 
         
       if(((LedState <<= 1) > 0x80) || (LedState == 0))  
       {
         LedState = 0x01;
       }
         
       // PA[0..8,11..15] = Output(Reserve PA9=TX,PA10=RX)    
       GPIO_WriteBit(GPIOA,GPIO_Pin_0  ,((LedState&0x01)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOA,GPIO_Pin_1  ,((LedState&0x02)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOA,GPIO_Pin_2  ,((LedState&0x04)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOA,GPIO_Pin_3  ,((LedState&0x08)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOA,GPIO_Pin_4  ,((LedState&0x10)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOA,GPIO_Pin_5  ,((LedState&0x20)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOA,GPIO_Pin_6  ,((LedState&0x40)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOA,GPIO_Pin_7  ,((LedState&0x80)<<0)?Bit_RESET:Bit_SET);
    
       GPIO_WriteBit(GPIOA,GPIO_Pin_8  ,((LedState&0x01)<<8)?Bit_RESET:Bit_SET);       
       //GPIO_WriteBit(GPIOA,GPIO_Pin_9  ,((LedState&0x02)<<8)?Bit_RESET:Bit_SET);  //PA9  = TX
       //GPIO_WriteBit(GPIOA,GPIO_Pin_10 ,((LedState&0x04)<<8)?Bit_RESET:Bit_SET);  //PA10 = RX
       GPIO_WriteBit(GPIOA,GPIO_Pin_11 ,((LedState&0x08)<<8)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOA,GPIO_Pin_12 ,((LedState&0x10)<<8)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOA,GPIO_Pin_13 ,((LedState&0x20)<<8)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOA,GPIO_Pin_14 ,((LedState&0x40)<<8)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOA,GPIO_Pin_15 ,((LedState&0x80)<<8)?Bit_RESET:Bit_SET);
       
       // PB[0,1,3..15] = Output(Reserve PB2=BOOT1:GND)
       GPIO_WriteBit(GPIOB,GPIO_Pin_0  ,((LedState&0x01)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOB,GPIO_Pin_1  ,((LedState&0x02)<<0)?Bit_RESET:Bit_SET);       
       //GPIO_WriteBit(GPIOB,GPIO_Pin_2  ,((LedState&0x04)<<0)?Bit_RESET:Bit_SET);  //PB2 = BOOT1(GND)
       GPIO_WriteBit(GPIOB,GPIO_Pin_3  ,((LedState&0x08)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOB,GPIO_Pin_4  ,((LedState&0x10)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOB,GPIO_Pin_5  ,((LedState&0x20)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOB,GPIO_Pin_6  ,((LedState&0x40)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOB,GPIO_Pin_7  ,((LedState&0x80)<<0)?Bit_RESET:Bit_SET);
    
       GPIO_WriteBit(GPIOB,GPIO_Pin_8  ,((LedState&0x01)<<8)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOB,GPIO_Pin_9  ,((LedState&0x02)<<8)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOB,GPIO_Pin_10 ,((LedState&0x04)<<8)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOB,GPIO_Pin_11 ,((LedState&0x08)<<8)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOB,GPIO_Pin_12 ,((LedState&0x10)<<8)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOB,GPIO_Pin_13 ,((LedState&0x20)<<8)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOB,GPIO_Pin_14 ,((LedState&0x40)<<8)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOB,GPIO_Pin_15 ,((LedState&0x80)<<8)?Bit_RESET:Bit_SET);
    
       // PC[0..13] = Output(Reserve PC14=OSCI,PC15=OSCO)
       GPIO_WriteBit(GPIOC,GPIO_Pin_0  ,((LedState&0x01)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOC,GPIO_Pin_1  ,((LedState&0x02)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOC,GPIO_Pin_2  ,((LedState&0x04)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOC,GPIO_Pin_3  ,((LedState&0x08)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOC,GPIO_Pin_4  ,((LedState&0x10)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOC,GPIO_Pin_5  ,((LedState&0x20)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOC,GPIO_Pin_6  ,((LedState&0x40)<<0)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOC,GPIO_Pin_7  ,((LedState&0x80)<<0)?Bit_RESET:Bit_SET);
    
       GPIO_WriteBit(GPIOC,GPIO_Pin_8  ,((LedState&0x01)<<8)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOC,GPIO_Pin_9  ,((LedState&0x02)<<8)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOC,GPIO_Pin_10 ,((LedState&0x04)<<8)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOC,GPIO_Pin_11 ,((LedState&0x08)<<8)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOC,GPIO_Pin_12 ,((LedState&0x10)<<8)?Bit_RESET:Bit_SET);
       GPIO_WriteBit(GPIOC,GPIO_Pin_13 ,((LedState&0x20)<<8)?Bit_RESET:Bit_SET);
       //GPIO_WriteBit(GPIOC,GPIO_Pin_14 ,((LedState&0x40)<<8)?Bit_RESET:Bit_SET);  // PC14 = MCU:OSCI
       //GPIO_WriteBit(GPIOC,GPIO_Pin_15 ,((LedState&0x80)<<8)?Bit_RESET:Bit_SET);  // PC15 = MCU:OSCO
              
       // PD[2] = Output(Reserve PD0=OSCIN,PD1=OSCOUT)
       //GPIO_WriteBit(GPIOD,GPIO_Pin_0  ,((LedState&0x01)<<0)?Bit_RESET:Bit_SET); // PD0 = RTC:OSCI
       //GPIO_WriteBit(GPIOD,GPIO_Pin_1  ,((LedState&0x02)<<0)?Bit_RESET:Bit_SET); // PD1 = RTC:OSCO
       GPIO_WriteBit(GPIOD,GPIO_Pin_2  ,((LedState&0x04)<<0)?Bit_RESET:Bit_SET);
     }      
  }  
}

/*------------------------------------------------------------------------------
  RTC Interrupt Handler
 *------------------------------------------------------------------------------*/
void RTCIntrHandler(void)
{
  if (RTC_GetITStatus(RTC_IT_SEC) != RESET)
  {
    /* Clear the RTC Second interrupt */
    RTC_ClearITPendingBit(RTC_IT_SEC);
    RTC_Update = 1;    
  }

} 

/*----------------------------------------------------------------------------
 STM32 Real Time Clock setup.
 initializes the RTC Prescaler and RTC counter register
 *----------------------------------------------------------------------------*/
void RtcSetup (void) 
{
  /* Enable PWR and BKP clocks */
  RCC_APB1PeriphClockCmd(RCC_APB1Periph_PWR | RCC_APB1Periph_BKP, ENABLE);

  /* Allow access to BKP Domain */
  PWR_BackupAccessCmd(ENABLE);

  /* Reset Backup Domain */
  BKP_DeInit();

  /* Enable LSE */
  RCC_LSEConfig(RCC_LSE_ON);
  /* Wait till LSE is ready */
  while (RCC_GetFlagStatus(RCC_FLAG_LSERDY) == RESET)
  {}

  /* Select LSE as RTC Clock Source */
  RCC_RTCCLKConfig(RCC_RTCCLKSource_LSE);

  /* Enable RTC Clock */
  RCC_RTCCLKCmd(ENABLE);

  /* Wait for RTC registers synchronization */
  RTC_WaitForSynchro();

  /* Wait until last write operation on RTC registers has finished */
  RTC_WaitForLastTask();

  /* Enable the RTC Second */
  RTC_ITConfig(RTC_IT_SEC, ENABLE);

  /* Wait until last write operation on RTC registers has finished */
  RTC_WaitForLastTask();

  /* Set RTC prescaler: set RTC period to 1sec */
  RTC_SetPrescaler(32767); /* RTC period = RTCCLK/RTC_PR = (32.768 KHz)/(32767+1) */

  /* Wait until last write operation on RTC registers has finished */
  RTC_WaitForLastTask();  
  
} // end of stm32_RtcSetup

/*******************************************************************************
* Function Name  : RCC_Configuration
* Description    : Configures the different system clocks.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void RCC_Configuration(void)
{   
  /* RCC system reset(for debug purpose) */
  RCC_DeInit();

  /* Enable HSE */
  RCC_HSEConfig(RCC_HSE_ON);

  /* Wait till HSE is ready */
  HSEStartUpStatus = RCC_WaitForHSEStartUp();

  if(HSEStartUpStatus == SUCCESS)
  {
    /* Enable Prefetch Buffer */
    FLASH_PrefetchBufferCmd(FLASH_PrefetchBuffer_Enable);

    /* Flash 2 wait state */
    FLASH_SetLatency(FLASH_Latency_2);
 	
    /* HCLK = SYSCLK */
    RCC_HCLKConfig(RCC_SYSCLK_Div1); 
  
    /* PCLK2 = HCLK */
    RCC_PCLK2Config(RCC_HCLK_Div1); 

    /* PCLK1 = HCLK/2 */
    RCC_PCLK1Config(RCC_HCLK_Div2);

    /* PLLCLK = 8MHz * 9 = 72 MHz */
    RCC_PLLConfig(RCC_PLLSource_HSE_Div1, RCC_PLLMul_9);

    /* Enable PLL */ 
    RCC_PLLCmd(ENABLE);

    /* Wait till PLL is ready */
    while(RCC_GetFlagStatus(RCC_FLAG_PLLRDY) == RESET)
    {
    }

    /* Select PLL as system clock source */
    RCC_SYSCLKConfig(RCC_SYSCLKSource_PLLCLK);

    /* Wait till PLL is used as system clock source */
    while(RCC_GetSYSCLKSource() != 0x08)
    {
    }
  }
}

/*******************************************************************************
* Function Name  : NVIC_Configuration
* Description    : Configures Vector Table base location.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void NVIC_Configuration(void)
{
#ifdef  VECT_TAB_RAM  
  /* Set the Vector Table base location at 0x20000000 */ 
  NVIC_SetVectorTable(NVIC_VectTab_RAM, 0x0); 
#else  /* VECT_TAB_FLASH  */
  /* Set the Vector Table base location at 0x08000000 */ 
  NVIC_SetVectorTable(NVIC_VectTab_FLASH, 0x0);   
#endif
}

/*******************************************************************************
* Function Name  : Delay
* Description    : Inserts a delay time.
* Input          : nCount: specifies the delay time length.
* Output         : None
* Return         : None
*******************************************************************************/
void Delay(vu32 nCount)
{
  for(; nCount != 0; nCount--);
}

#ifdef  DEBUG
/*******************************************************************************
* Function Name  : assert_failed
* Description    : Reports the name of the source file and the source line number
*                  where the assert_param error has occurred.
* Input          : - file: pointer to the source file name
*                  - line: assert_param error line source number
* Output         : None
* Return         : None
*******************************************************************************/
void assert_failed(u8* file, u32 line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif

/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
